GPU_EQUATES:        
        A_0             .equr   R1
        A_1             .equr   R2
        A_2             .equr   R3
        A_3             .equr   R4
        A_4             .equr   R5
        A_5             .equr   R6
        A_6             .equr   R7
        A_7             .equr   R8
        D_0             .equr   R9
        D_1             .equr   R10
        D_2             .equr   R11
        D_3             .equr   R12
        D_4             .equr   R13
        D_5             .equr   R14
        D_6             .equr   R15
        D_7             .equr   R16
        Junk            .equr   R19
        Orig_Len        .equr   R20
        Return          .equr   R21
        D0_BITS         .equr   R22
        S_P             .equr   R23
        mask1           .equr   R24
        mask2           .equr   R25

        .MACRO  Get1Bit frig

        move    D_7,Junk
        add     D_7,D_7
        jr      NE,\frig
        nop
        subqt   #1,A_5
        loadb   (A_5),D_7
        add     Junk,Junk       ; recreate carry flag
        addc    D_7,D_7         ; add with it
        rorq    #9,D_7          ; and then frig city!!
        shlq    #1,D_7          ; !!!!!!!!!!!!!!!!!!!!
        .ENDM


;*******************
;       JSR Macro
;       Trashes R19
;*******************
        .MACRO  JSR     dest
        subqt   #4,S_P          ; adjust the stack pointer
        nop
        move    PC,Junk         ; determine current program address
        addq    #16,Junk        ; new address for after this macro
        nop
        store   Junk,(S_P)      ; push return address onto stack
        movei   #\dest,Junk     ; load up subroutine address
        jump    (Junk)          ; jump to subroutine
        nop                     ; jump doesn't occur until this instr
        .ENDM

;*******************
;       RTS Macro
;       Trashes R19
;*******************
        .MACRO  RTS
        load    (S_P),Junk      ; load up return address
        jump    (Junk)          ; jump back to return address
        addqt   #4,S_P          ; adjust the stack pointer
        .ENDM
;*****************************
;       Macro to call D0 Bits
;*****************************
        .MACRO  JSR_D0_Bits
        move    PC,Return
        jump    (D0_BITS)
        addq    #6,Return       ; Determine Return Address
        .ENDM

        .MACRO  D0_RTS
        jump    (Return)
        .ENDM
;*******************
;       BCC Macro
;       Trashes R19
;*******************
        .MACRO  BCC     dest
        movei   #\dest,Junk
        jump    CC,(Junk)
        nop
        .ENDM

;*******************
;       BMI Macro
;       Trashes R19
;*******************
        .MACRO  BMI     dest
        movei   #\dest,Junk
        jump    MI,(Junk)
        nop
        .ENDM

;*******************
;       BPL Macro
;       Trashes R19
;*******************
        .MACRO  BPL     dest
        movei   #\dest,Junk
        jump    PL,(Junk)
        nop
        .ENDM

;*******************
;       BHI Macro
;       Trashes R19
;*******************
        .MACRO  BHI     dest
        movei   #\dest,Junk
        jump    HI,(Junk)
        nop
        .ENDM
;*******************
;       BEQ Macro
;       Trashes R19
;*******************
        .MACRO  BEQ     dest
        movei   #\dest,Junk
        jump    EQ,(Junk)
        nop
        .ENDM

;*******************
;       DBF Macro
;       Trashes R19
;*******************
        .MACRO  DBF     reggie,dest
        movei   #\dest,Junk
        subq    #1,\reggie
        jump    PL,(Junk)
        nop
        .ENDM

;*******************
;       SWAP Macro
;*******************
        .MACRO  SWAP    reggie
        rorq    #16,\reggie
        .ENDM
