; --------------------------------------------------------------------
; Register des ATARI Jaguar
; --------------------------------------------------------------------
; First Version 0.1  03.10.96
;               0.2  12.10.96
; 		0.3  25.11.96
; 		0.4  01.12.96
;		0.5  18.01.97
; Last Update   0.6  17.07.97
; --------------------------------------------------------------------

; RISC Chips
G_RAM		EQU $F03000	; GPU Internal RAM
D_RAM		EQU $F1B000	; DSP Internal RAM
G_FLAGS         EQU $F02100     ; GPU PC und Status Register
D_FLAGS         EQU $F1A100     ; DSP PC und Status Register
G_MTXC          EQU $F02104     ; GPU
D_MTXC          EQU $F1A104     ; DSP
G_MTXA          EQU $F02108     ; GPU
D_MTXA          EQU $F1A108     ; DSP
G_END           EQU $F0210C     ; GPU
D_END           EQU $F1A10C     ; DSP
G_PC            EQU $F02110     ; GPU Program Counter
D_PC            EQU $F1A110     ; DSP Program Counter
G_CTRL          EQU $F02114     ; GPU
D_CTRL          EQU $F1A114     ; DSP
G_HIDATA        EQU $F02118     ; GPU
D_MOD           EQU $F1A118     ; DSP
G_DIVCTRL       EQU $F0211C     ; GPU
D_DIVCTRL       EQU $F1A11C     ; DSP
G_REMAIN        EQU $F0211C     ; GPU
D_REMAIN        EQU $F1A11C     ; DSP
D_MACHI         EQU $F1A120     ; DSP

; TOM
MEMCON1         EQU $F00000     ; Memory Configuration 1
MEMCON2         EQU $F00002     ; Memory Configuration 2
INT1            EQU $F000E0     ; Interrupt Control INT1
INT2            EQU $F000E2     ; Interrupt Control INT2
PIT             EQU $F00050     ; Programmable Timer

; JERRY
JOYSTICK        EQU $F14000     ; Digital Joypad
JOYBUTS         EQU $F14002     ; Digital Joypad Buttons
ANAJOY          EQU $F17C00     ; Analog Joystick
R_DAC           EQU $F1A148     ; Right Digital Analog Converter
L_DAC           EQU $F1A14C     ; Left Digital Analog Converter
SCLK            EQU $F1A150     ; Sampling Rate
SMODE           EQU $F1A154     ; Sound production
CLK1            EQU $F10010     ; Clock Register
CLK2            EQU $F10012     ; Video Clock frequence
CHRO_CLK        EQU $F10014     ; color DAC
JPIT            EQU $F10000     ; Programmable Timer
ASIDATA         EQU $F10030     ; Network Receive
ASICTRL         EQU $F10032     ; Network Control
ASICLK          EQU $F10034     ; Network Transfer Speed

; VIDEO
VMODE           EQU $F00028     ; Video Processing
BG              EQU $F00058     ; Linebuffer
BORD1           EQU $F0002A     ; Border Color
HP              EQU $F0002E     ; Cyles in a Halfline
HBB             EQU $F00030     ; Begin Horizontal Blank
HBE             EQU $F00032     ; End Horizontal Blank
HS              EQU $F00034     ; HSYNC Signal
HVS             EQU $F00036     ; VSYNC Signal
HDB1            EQU $F00038     ; Linebuffer 1
HDB2            EQU $F0003A     ; Linebuffer 2
HDE             EQU $F0003C     ; Cycle Number
HEQ             EQU $F00054     ; EQ Signal
VP              EQU $F0003E     ; Number of Scanlines
VBB             EQU $F00040     ; Start of vertical Blanking
VBE             EQU $F00042     ; End of vertical Blanking
VS              EQU $F00044     ; Start of VSYNC
VDB             EQU $F00046     ; Display Begin
VDE             EQU $F00048     ; Display End
VEB             EQU $F0004A     ; Begin equalization Section
VEE             EQU $F0004C     ; End equalization Section
GENLOCK         EQU $F00026     ; Genlocking
CLUT            EQU $F00400     ; Color Lockup Table
HC              EQU $F00004     ; Active Linebuffer
VC              EQU $F00006     ; Current Scanline being processed
VI              EQU $F0004E     ; VC Register
LPH             EQU $F00008     ; Horizontal latch for light Gun
LPV             EQU $F0000A     ; Vertical latch value for light Gun
LBUFA           EQU $F00800     ; Actuall Adress Linebuffer 1
LBUFB           EQU $F01000     ; Actuell Adress Linebuffer 2

; BLITTER
B_STATUS        EQU $F02238     ; Blitter Status
B_CMD		EQU $F02238	; Blitter Control
B_COUNT         EQU $F0223C     ; Blitter
B_IINC          EQU $F02274     ; Blitter in Pixelmode
B_I3		EQU $F0227C	; Blitter in Phrasemode
B_I2		EQU $F02280	; Blitter in Phrasemode
B_I1		EQU $F02284	; Blitter in Phrasemode
B_I0		EQU $F02288	; Blitter in Phrasemode
B_ZINC		EQU $F02274	; Blitter in Pixelmode
B_Z3            EQU $F0228C     ; Blitter in Phrasemode
B_Z2            EQU $F02290     ; Blitter in Phrasemode
B_Z1            EQU $F02294     ; Blitter in Phrasemode
B_Z0            EQU $F02298     ; Blitter in Phrasemode
B_DSTD          EQU $F02248     ; Blitter
B_SRCD          EQU $F02240     ; Blitter
B_STOP          EQU $F02278     ; Blitter
B_PATD		EQU $F02268	; Blitter
A1_BASE         EQU $F02200     ; Blitter
A1_FLAGS        EQU $F02204     ; Blitter
A1_CLIP         EQU $F02208     ; Blitter
A1_PIXEL        EQU $F0220C     ; Blitter
A1_FPIXEL       EQU $F02218     ; Blitter
A1_INC          EQU $F0221C     ; Blitter
A1_FINC         EQU $F02220     ; Blitter
A1_STEP         EQU $F02210     ; Blitter
A1_FSTEP        EQU $F02214     ; Blitter
A2_BASE         EQU $F02224     ; Blitter
A2_FLAGS        EQU $F02228     ; Blitter
A2_PIXEL        EQU $F02230     ; Blitter
A2_MASK         EQU $F0222C     ; Blitter
A2_STEP         EQU $F02234     ; Blitter

; OBJECT PROCESSOR (OP)
OLP             EQU $F00020     ; Adresse Object List
OB              EQU $F00010     ; Not what you think, it's the Object Data
OBF             EQU $F00026     ; OP
BRANCHOBJ	EQU 3
O_BREQ		EQU (0<<14)	; CC field of BRANCH objects
O_BRGT		EQU (1<<14)
O_BRLT		EQU (2<<14)
O_BROP		EQU (3<<14)
O_BRHALF	EQU (4<<14)

; Sonstige
LEVEL2          EQU $0100       ; Interrupt Adresse
ENDRAM		EQU $200000	; Ende DRAM
INITSTACK	EQU ENDRAM-4	; Start Stack

; BLITTER Kommandos
SRCEN		EQU $00000001	; d00:     source data read (inner loop)
SRCENZ		EQU $00000002	; d01:     source Z read (inner loop)
SRCENX		EQU $00000004	; d02:     source data read (realign)
DSTEN		EQU $00000008	; d03:     dest data read (inner loop)
DSTENZ		EQU $00000010	; d04:     dest Z read (inner loop)
DSTWRZ		EQU $00000020	; d05:     dest Z write (inner loop)
CLIP_A1		EQU $00000040	; d06:     A1 clipping enable
UPDA1F		EQU $00000100	; d08:     A1 update step fraction
UPDA1		EQU $00000200	; d09:     A1 update step
UPDA2		EQU $00000400	; d10:     A2 update step
DSTA2		EQU $00000800	; d11:     reverse usage of A1 and A2
GOURD		EQU $00001000	; d12:     enable Gouraud shading
ZBUFF		EQU $00002000	; d13:     polygon Z data updates
TOPBEN		EQU $00004000	; d14:     intensity carry into byte
TOPNEN		EQU $00008000	; d15:     intensity carry into nibble
PATDSEL		EQU $00010000	; d16:     Select pattern data
ADDDSEL		EQU $00020000	; d17:     diagnostic
				; d18-d20: Z comparator inhibit
ZMODELT		EQU $00040000	; 	     source < destination
ZMODEEQ		EQU $00080000	;	     source = destination
ZMODEGT		EQU $00100000	;	     source > destination
				; d21-d24: Logic function control
LFU_NAN		EQU $00200000	; 	     !source & !destination
LFU_NA		EQU $00400000	; 	     !source &  destination
LFU_AN		EQU $00800000	; 	      source & !destination
LFU_A		EQU $01000000	; 	      source &  destination

CMPDST		EQU $02000000	; d25:     pixel compare pattern & dest
BCOMPEN		EQU $04000000	; d26:     bit compare write inhibit
DCOMPEN		EQU $08000000	; d27:     data compare write inhibit
BKGWREN		EQU $10000000	; d28:     data write back
BUSHI		EQU $20000000	; d29	   blitter priority
SRCSHADE	EQU $40000000	; d30:	   shade src data w/IINC value

; The following are ALL 16 possible logical operations of the LFUs
LFU_ZERO	EQU $00000000	; All Zeros
LFU_NSAND	EQU $00200000	; NOT Source AND NOT Destination
LFU_NSAD	EQU $00400000	; NOT Source AND Destination
LFU_NOTS	EQU $00600000	; NOT Source
LFU_SAND	EQU $00800000	; Source AND NOT Destination
LFU_NOTD	EQU $00A00000	; NOT Destination
LFU_N_SXORD	EQU $00C00000	; NOT (Source XOR Destination)
LFU_NSORND	EQU $00E00000	; NOT Source OR NOT Destination
LFU_SAD		EQU $01000000	; Source AND Destination
LFU_SXORD	EQU $01200000	; Source XOR Destination
LFU_D		EQU $01400000	; Destination
LFU_NSORD	EQU $01600000	; NOT Source OR Destination
LFU_S		EQU $01800000	; Source
LFU_SORND	EQU $01A00000	; Source OR NOT Destination
LFU_SORD	EQU $01C00000	; Source OR Destination
LFU_ONE		EQU $01E00000	; All Ones

; These are some common combinations with less boolean names
LFU_REPLACE	EQU $01800000	; Source REPLACEs destination
LFU_XOR		EQU $01200000	; Source XOR with destination
LFU_CLEAR	EQU $00000000	; CLEAR destination

;
; BLITTER Flags (A1 or A2) register equates
;

; Pitch d00-d01:
;	distance between pixel phrases
PITCH1		EQU $00000000	; 0 phrase gap
PITCH2		EQU $00000001	; 1 phrase gap
PITCH4		EQU $00000002	; 3 phrase gap
PITCH3		EQU $00000003	; 2 phrase gap

; Pixel d03-d05
;	bit depth (2^n)
PIXEL1		EQU $00000000	; n = 0	
PIXEL2		EQU $00000008	; n = 1	
PIXEL4		EQU $00000010	; n = 2	
PIXEL8		EQU $00000018	; n = 3	
PIXEL16		EQU $00000020	; n = 4	
PIXEL32		EQU $00000028	; n = 5	

; Z offset d06-d08
;	offset from phrase of pixel data from its corresponding
;	Z data phrases
ZOFFS0		EQU $00000000	; offset = 0	UNUSED
ZOFFS1		EQU $00000040	; offset = 1
ZOFFS2		EQU $00000080	; offset = 2
ZOFFS3		EQU $000000C0	; offset = 3
ZOFFS4		EQU $00000100	; offset = 4
ZOFFS5		EQU $00000140	; offset = 5
ZOFFS6		EQU $00000180	; offset = 6
ZOFFS7		EQU $000001C0	; offset = 7	UNUSED

; Width d09-d14
;	width used for address generation
;	This is a 6-bit floating point value in pixels
;	4-bit unsigned exponent
;	2-bit mantissa with implied 3rd bit of 1
WID2		EQU $00000800	; 1.00 X 2^1  ( 4<<9)
WID4 		EQU $00001000	; 1.00 X 2^2  ( 8<<9)
WID6		EQU $00001400	; 1.10 X 2^2  (10<<9)
WID8		EQU $00001800	; 1.00 x 2^3  (12<<9)
WID10		EQU $00001A00	; 1.01 X 2^3  (13<<9)
WID12		EQU $00001C00	; 1.10 X 2^3  (14<<9)
WID14		EQU $00001E00	; 1.11 X 2^3  (15<<9)
WID16		EQU $00002000	; 1.00 X 2^4  (16<<9)
WID20		EQU $00002200	; 1.01 X 2^4  (17<<9)
WID24		EQU $00002400	; 1.10 X 2^4  (18<<9)
WID28		EQU $00002600	; 1.11 X 2^4  (19<<9)
WID32		EQU $00002800	; 1.00 X 2^5  (20<<9)
WID40		EQU $00002A00	; 1.01 X 2^5  (21<<9)
WID48		EQU $00002C00	; 1.10 X 2^5  (22<<9)
WID56		EQU $00002E00	; 1.11 X 2^5  (23<<9)
WID64		EQU $00003000	; 1.00 X 2^6  (24<<9)
WID80		EQU $00003200	; 1.01 X 2^6  (25<<9)
WID96		EQU $00003400	; 1.10 X 2^6  (26<<9)
WID112		EQU $00003600	; 1.11 X 2^6  (27<<9)
WID128		EQU $00003800	; 1.00 X 2^7  (28<<9)
WID160		EQU $00003A00	; 1.01 X 2^7  (29<<9)
WID192		EQU $00003C00	; 1.10 X 2^7  (30<<9)
WID224		EQU $00003E00	; 1.11 X 2^7  (31<<9)
WID256		EQU $00004000	; 1.00 X 2^8  (32<<9)
WID320		EQU $00004200	; 1.01 X 2^8  (33<<9)
WID384		EQU $00004400	; 1.10 X 2^8  (34<<9)
WID448		EQU $00004600	; 1.11 X 2^8  (35<<9)
WID512		EQU $00004800	; 1.00 X 2^9  (36<<9)
WID640		EQU $00004A00	; 1.01 X 2^9  (37<<9)
WID768		EQU $00004C00	; 1.10 X 2^9  (38<<9)
WID896		EQU $00004E00	; 1.11 X 2^9  (39<<9)
WID1024		EQU $00005000	; 1.00 X 2^10 (40<<9)
WID1280		EQU $00005200	; 1.01 X 2^10 (41<<9)
WID1536		EQU $00005400	; 1.10 X 2^10 (42<<9)
WID1792		EQU $00005600	; 1.11 X 2^10 (43<<9)
WID2048		EQU $00005800	; 1.00 X 2^11 (44<<9)
WID2560		EQU $00005A00	; 1.01 X 2^11 (45<<9)
WID3072		EQU $00005C00	; 1.10 X 2^11 (46<<9)
WID3584		EQU $00005E00	; 1.11 X 2^11 (47<<9)

; X add control d16-d17
;	controls the update of the X pointer on each pass
;	round the inner loop
XADDPHR		EQU $00000000	; 00 - add phrase width and truncate
XADDPIX		EQU $00010000	; 01 - add pixel size (add 1)	
XADD0		EQU $00020000	; 10 - add zero
XADDINC		EQU $00030000	; 11 - add the increment

; Y add control	d18
;	controls the update of the Y pointer within the inner loop.
;	it is overridden by the X add control if they are in add increment
YADD0		EQU $00000000	; 00 - add zero
YADD1		EQU $00040000	; 01 - add 1

; X sign d19
;	add or subtract pixel size if X add control = 01 (XADDPIX)
XSIGNADD	EQU $00000000	; 0 - add pixel size
XSIGNSUB	EQU $00080000	; 1 - subtract pixel size

; Y sign d20
;	add or subtract pixel size if Y add control = 01 (YADD1)
YSIGNADD	EQU $00000000	; 0 - add 1
YSIGNSUB	EQU $00100000	; 1 - sub 1
